<?php
/*
Plugin Name: Divi Carousel Lite
Plugin URI:  https://divitorque.com/
Description: A simple carousel for Divi.
Version:     1.2.14
Author: Divi Torque
Author URI:  https://divitorque.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: wdcl-wow-divi-carousel-lite
Domain Path: /languages
*/

if (!defined('ABSPATH')) {
    exit;
}

define('TC_PLUGIN_VERSION', '1.2.14');
define('TC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('TC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('TC_PLUGIN_ASSETS', trailingslashit(TC_PLUGIN_URL . 'assets'));
define('TC_PLUGIN_FILE', __FILE__);
define('TC_PLUGIN_BASE', plugin_basename(__FILE__));

function wdcl_plugin_activation_hook()
{
    if (get_option('wdcl_activation_time') === false) {
        update_option('wdcl_activation_time', strtotime("now"));
    }

    update_option('wdcl_active_version', TC_PLUGIN_VERSION);
    update_option('has_wdcl', true);
}

wdcl_plugin_activation_hook();

require_once TC_PLUGIN_DIR . 'includes/assets-manager.php';
require_once TC_PLUGIN_DIR . 'includes/special-notices.php';

if (!function_exists('wdcl_initialize_extension')) :

    function wdcl_initialize_extension()
    {
        require_once plugin_dir_path(__FILE__) . 'includes/WowDiviCarouselLite.php';
    }

    add_action('divi_extensions_init', 'wdcl_initialize_extension');
endif;

require_once 'plugin.php';
