<?php

namespace TorqueCarousel;

/**
 * Main class plugin
 */
class Plugin
{
    /**
     * @var Plugin
     */
    private static $instance;

    const BASENAME = TC_PLUGIN_BASE;
    const DOCS_LINK = 'https://divitorque.com/docs/';
    const PRICING_LINK = 'https://divitorque.com/pricing/';

    /**
     * Plugin constructor.
     */
    private function __construct()
    {
        $this->load_dependencies();
        $this->define_hooks();
    }

    /**
     * Get an instance of the Plugin
     *
     * @return Plugin
     */
    public static function get_instance()
    {
        if (null === self::$instance) {
            self::$instance = new self();
            self::$instance->init();
        }

        return self::$instance;
    }

    /**
     * Load required files
     */
    private function load_dependencies()
    {
    }

    /**
     * Define WP hooks
     */
    private function define_hooks()
    {
        add_filter('plugin_action_links_' . self::BASENAME, [$this, 'add_plugin_action_links']);
    }

    /**
     * Initialize required instances
     */
    public function init()
    {
    }

    /**
     * On plugin activation
     */
    public function on_activation()
    {
    }

    /**
     * Redirect to plugin page after activation
     */
    public function plugin_activation_redirect()
    {
    }

    /**
     * Load plugin translations
     */
    public function load_textdomain()
    {
    }

    /**
     * Add action links for the plugin
     *
     * @param array $links
     * @return array
     */
    public function add_plugin_action_links($links)
    {
        $links[] = sprintf('<a href="%s" target="_blank" style="color: #197efb;font-weight: 600;">%s</a>', self::DOCS_LINK, __('Docs', 'divitorque'));
        $links[] = sprintf('<a href="%s" target="_blank" style="color: #FF6900;font-weight: 600;">%s</a>', self::PRICING_LINK, __('Get Torque Pro', 'divitorque'));
        return $links;
    }

    /**
     * Initialize extension
     */
    public function init_extension()
    {
    }
}

Plugin::get_instance();
